//
//  MCTrackedEvent.h
//  MCServerSupport
//
//  Created by Brent Gulanowski on 09/05/08.
//  Copyright 2008 Marketcircle, Inc. All rights reserved.
//

#import <CoreData/NSManagedObject.h>


extern NSString *kMCETEntityTrackedEvent;


enum {
	kMCEventTypeClientGeneric  = 0x100,
	kMCEventTypeClientConnect,
	kMCEventTypeClientError,

	kMCEventTypeServerGeneric  = 0x200,
	kMCEventTypeServerError
};

typedef unsigned MCEventType;


@interface MCTrackedEvent : NSManagedObject {

}

+ (NSString *)nameForEventType:(MCEventType)aType;

- (NSString *)eventName;

// If there is no explicitly set message, this will return a generic message
- (NSString *)message;

@end
